function getURLVar(key) {
	var value = [];

	var query = String(document.location).split('?');

	if (query[1]) {
		var part = query[1].split('&');

		for (i = 0; i < part.length; i++) {
			var data = part[i].split('=');

			if (data[0] && data[1]) {
				value[data[0]] = data[1];
			}
		}

		if (value[key]) {
			return value[key];
		} else {
			return '';
		}
	}
}

function filter() {
	var url = 'index.php?route=editors/category&user_token=' + getURLVar('user_token');

	var filter_category_id = $('input[name=\'filter_category_id\']').val();

	if (filter_category_id) {
		url += '&filter_category_id=' + encodeURIComponent(filter_category_id);
	}
	
	var filter_sort_order = $('input[name=\'filter_sort_order\']').val();

	if (filter_sort_order) {
		url += '&filter_sort_order=' + encodeURIComponent(filter_sort_order);
	}

	var filter_status = $('select[name=\'filter_status\']').val();

	if (filter_status != '*') {
		url += '&filter_status=' + encodeURIComponent(filter_status);
	}

	var filter_image = $('select[name=\'filter_image\']').val();

	if (filter_image != '*') {
		url += '&filter_image=' + encodeURIComponent(filter_image);
	}

	location = url;
}

$(document).ready(function() {
	var text_none = $('#product-text-none').val();
	
	$('input[name=\'filter_category\']').autocomplete({
		'source': function(request, response) {
			$.ajax({
				url: 'index.php?route=editors/category/autocomplete&user_token=' + getURLVar('user_token') + '&filter_name=' +  encodeURIComponent(request),
				dataType: 'json',
				success: function(json) {
					json.unshift({
						category_id: 0,
						name: text_none
					});	
					
					response($.map(json, function(item) {
						return {
							label: item['name'],
							value: item['category_id']
						}
					}));
				}
			});
		},
		'select': function(item) {
			$('input[name=\'filter_category\']').val(item['label']);
			$('input[name=\'filter_category_id\']').val(item['value']);
		}
	});
});

function linkImage(category_id) {
	var element = $('#category-image-' + category_id);
	
	$('#modal-image').remove();
	$.ajax({
		url: 'index.php?route=common/filemanager&user_token=' + getURLVar('user_token') + '&target=' + $(element).find('input').attr('id') + '&thumb=' + $(element).attr('id'),
		dataType: 'html',
		success: function(html) {
			$('body').append('<div id="modal-image" class="modal">' + html + '</div>');

			$('#modal-image').modal('show');
		}
	});
}

function editImage(category_id) {
	var image = $('#category-image').val();
	var type = 'category_image';
	
	$.ajax({
		url: 'index.php?route=editors/catalog_edit/catalog&user_token=' + getURLVar('user_token') + '&category_id=' + category_id + '&image=' + image + '&type=' + type,
		type: 'post',
		dataType: 'json',
		success: function(json) {									
			if (json['error']) {								
				$('.messages-body').html('<div class="alert alert-danger alert-messages"><i class="fa fa-check-circle"></i> ' + json['error'] + '</div>');$('.maxy-backdrop, .messages-body').show().delay(1500).fadeOut(500);
			}
									
			if (json['success']) {
				$('.messages-body').html('<div class="alert alert-success alert-messages"><i class="fa fa-check-circle"></i> ' + json['success'] + '</div>');$('.maxy-backdrop, .messages-body').show().delay(1000).fadeOut(500);			
								
				$('#category-image' + category_id).load('index.php?route=editors/catalog_edit/loadCategoryImage&user_token=' + getURLVar('user_token') + '&category_id=' + category_id);
				$('#close-image-' + category_id).trigger('click');
			}
		}	
	});
	
	$('#category-image-' + category_id).on('hide.bs.modal', function () {
		$('#category-image').attr('value', '');
	});
}

function imageClear(category_id) {
	var placeholder = $('#category-placeholder').val();
	
	$('#category-image-' + category_id).find('a').find('img').attr('src', placeholder);
	$('#category-image').attr('value', placeholder);
}

function getName(category_id) {
	$('#category-name-content-' + category_id).load('index.php?route=editors/catalog_edit/getCategoryName&user_token=' + getURLVar('user_token') + '&category_id=' + category_id);
}

function editSort(category_id) {
	var sort_order = $('#input-sort' + category_id).val();
	var type = 'category_sort_order';
							
	$.ajax({
		url: 'index.php?route=editors/catalog_edit/catalog&user_token=' + getURLVar('user_token') + '&category_id=' + category_id + '&sort_order=' + sort_order + '&type=' + type,
		type: 'post',
		dataType: 'json',
		success: function(json) {									
			if (json['error']) {								
				$('.messages-body').html('<div class="alert alert-danger alert-messages"><i class="fa fa-check-circle"></i> ' + json['error'] + '</div>');$('.maxy-backdrop, .messages-body').show().delay(1500).fadeOut(500);
			}
									
			if (json['success']) {
				$('.messages-body').html('<div class="alert alert-success alert-messages"><i class="fa fa-check-circle"></i> ' + json['success'] + '</div>');$('.maxy-backdrop, .messages-body').show().delay(1000).fadeOut(500);			
				
				if (sort_order != '') {
					$('#category-sort' + category_id).html(sort_order);
				} else {
					$('#category-sort' + category_id).html('0');
				}

				$('#close-sort-' + category_id).trigger('click');
			}
		}
	});
}

function sortClear(category_id) {
	$('#input-sort' + category_id).val('');
}

function editButtons(category_id, type) {
	var value_data = '';
	
	if (type == 'top') {
		var top = $('#category-top-' + category_id).find('input[name=\'tops\']').val();
	} else if (type == 'category_status') {
		var status = $('#category-status-' + category_id).find('input[name=\'statuses\']').val();
	}
	
	if (top == 0 || status == 0) {
		value_data = 1;
	} else {
		value_data = 0;
	}
	
	$.ajax({
		url: 'index.php?route=editors/catalog_edit/catalog&user_token=' + getURLVar('user_token') + '&category_id=' + category_id + '&type=' + type + '&value_data=' + value_data,
		type: 'post',
		dataType: 'json',
		success: function(json) {
			if (json['error']) {
				$('.messages-body').html('<div class="alert alert-danger alert-messages"><i class="fa fa-check-circle"></i> ' + json['error'] + '</div>');$('.maxy-backdrop, .messages-body').show().delay(1500).fadeOut(500);
			}

			if (json['success']) {
				if (type == 'top') {
					if (top == 0) {
						$('#top-' + category_id).html('<span class="btn btn-success btn-sm"><i class="fa fa-check-circle"></i></span>');
						$('#category-top-' + category_id).find('input[name=\'tops\']').val('1');
					} else {
						$('#top-' + category_id).html('<span class="btn btn-danger btn-sm"><i class="fa fa-power-off"></i></span>');
						$('#category-top-' + category_id).find('input[name=\'tops\']').val('0');
					}
				} else if (type == 'category_status') {
					if (status == 0) {
						$('#status-' + category_id).html('<span class="btn btn-success btn-sm"><i class="fa fa-check-circle"></i></span>');
						$('#category-status-' + category_id).find('input[name=\'statuses\']').val('1');
					} else {
						$('#status-' + category_id).html('<span class="btn btn-danger btn-sm"><i class="fa fa-power-off"></i></span>');
						$('#category-status-' + category_id).find('input[name=\'statuses\']').val('0');
					}
				}
			}
		},
		error: function(xhr, ajaxOptions, thrownError) {
			alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
		}
	});	
}

function editMore(category_id, val) {	
	$('#category-more-' + category_id).popoverMaxy('hide');
	$('#modal-category-edit').modal('show');
		
	$('#modal-category-edit').on('hide.bs.modal', function() {
		$('#modal-category-content').empty();
	});
	
	$('#modal-category-content').load('index.php?route=editors/catalog_edit/edit_category_' + val + '&user_token=' + getURLVar('user_token') + '&category_id=' + category_id);
}